#ifndef _VH7PC_H_
#define _VH7PC_H_

/* CMDU uses big endian order: 0x_buf[0]_buf[1]_buf[2]_buf[3] */
#define CMDU			0xb8020000

/* known command lists
 * command: command arguments
 * value: actual value
 * mode: when command is affected under the mode.
 *	 A: all mode, C: CD mode, T: Tuner mode, t: tape mode, M: MD mode
 * <...>: explanation.
 * range: accepted parameter range that is added to value.
 */
/*      command                         value    mode */
#define CMD_POWEROFF		(CMDU | 0x0680) /* A <power on> */
#define CMD_POWERON		(CMDU | 0x0681) /* A <power off> */

#define CMD_INPUT_TUNER		(CMDU | 0x0091) /* A <change input to tuner> */
#define CMD_INPUT_CD		(CMDU | 0x0092) /* A <change input to cd> */
#define CMD_INPUT_MD		(CMDU | 0x01d2) /* A <change input to md> */
#define CMD_INPUT_TAPEAUX	(CMDU | 0x0095) /* A <change input to tape/aux> */
#define CMD_INPUT_PCUSB		(CMDU | 0x0093) /* A <change input to pc/usb> */

#define CMD_VOLUME		(CMDU | 0x4d00) /* A, <set volume> range:0..50, cancel-mute */
#define CMD_MUTE		(CMDU | 0x009c)	/* A, <toggle mute> toggle:mute-on/off, mute-on is lost by volume control */
#define CMD_NB	 		(CMDU | 0x014b) /* A, <toggle tone mode> toggle:nb1/nb2/normal */

#define CMD_INPUT_NEXT		(CMDU | 0x01c1)	/* A, <MD/TAPE input +1> */
#define CMD_INPUT_PREV		(CMDU | 0x01c0)	/* A, <MD/TAPE input -1> */

#define CMD_CD_STOP		(CMDU | 0x00c9) /* C, <stop CD> */
#define CMD_CD_PLAY		(CMDU | 0x00cb) /* A, <play cd> toggle:PAUSE<->PLAY, CD mode then play CD, cancel ff/fb */
#define CMD_CD_REPEAT		(CMDU | 0x00cc) /* C, <toggle cd repeat mode> toggle:rep/repall/normal */
#define CMD_CD_CH_PREV		(CMDU | 0x00ce) /* C, <cd track -1> (random mode: restart playing current track) */
#define CMD_CD_CH_NEXT		(CMDU | 0x00cf) /* C, <cd track +1> (random mode: reselect random track) */
#define CMD_CD_EJECT		(CMDU | 0x018d)	/* A, <cd eject> */
#define CMD_CD_RANDOM		(CMDU | 0x01d4) /* C, <change randome play mode> toggle:random/normal */
#define CMD_CD_CH_SET		(CMDU | 0x4400) /* C, <set track> range:001..159(?) (invalid track: ignored) */
#define CMD_CD_FF		(CMDU | 0x0007) /* C, <ff> */
#define CMD_CD_FB		(CMDU | 0x0006) /* C, <fb> */

#define CMD_TUNER_BAND		(CMDU | 0x008f) /* A, <move tuner mode then toggle band> toggle:AM/FM */
#define CMD_TUNER_AUTOMONO	(CMDU | 0x0118) /* T, <toggle stereo/mono> toggle:AUTO/MONO */
#define CMD_TUNER_CH_NEXT	(CMDU | 0x0107) /* A, <tuner channel +1> */
#define CMD_TUNER_CH_PREV	(CMDU | 0x0106) /* A, <tuner channel -1> */
#define CMD_TUNER_CH_SET	(CMDU | 0x4c00) /* T, <set channel> range:1..40 */

#define CMD_MD_PLAY		(CMDU | 0x01d8) /* M, <unknown> */
#define CMD_MD_STOP		(CMDU | 0x01d9) /* M, <unknown> */
#define CMD_MD_PAUSE		(CMDU | 0x01da) /* M, <unknown> */
#define CMD_MD_RECORD		(CMDU | 0x01db) /* M, <unknown> */
#define CMD_MD_OTE		(CMDU | 0x0040) /* M, <unknown> */
#define CMD_MD_SK_NEXT		(CMDU | 0x01dd) /* M, <unknown> */
#define CMD_MD_SK_PREV		(CMDU | 0x01dc) /* M, <unknown> */
#define CMD_MD_CH_SET		(CMDU | 0x4500) /* M, <unknown> */
#define CMD_MD_FF		(CMDU | 0x01df) /* M, <unknown> */
#define CMD_MD_FB		(CMDU | 0x01de) /* M, <unknown> */
#define CMD_MD_ALLE		(CMDU | 0x06d9) /* M, <unknown> */
#define CMD_MD_TRACKE		(CMDU | 0x06da) /* M, <unknown> */
#define CMD_MD_DIVIDE		(CMDU | 0x06db) /* M, <unknown> */
#define CMD_MD_COMBINE		(CMDU | 0x06dc) /* M, <unknown> */
#define CMD_MD_REPEAT		(CMDU | 0x02cf) /* M, <unknown> */
#define CMD_MD_RANDOM		(CMDU | 0x0342) /* M, <unknown> */
#define CMD_MD_EJECT		(CMDU | 0x0340) /* M, <unknown> */

#define CMD_TAPE_REV		(CMDU | 0x00d8) /* t, <unknown> */
#define CMD_TAPE_FWD		(CMDU | 0x00d9) /* t, <unknown> */
#define CMD_TAPE_FB		(CMDU | 0x00da) /* t, <unknown> */
#define CMD_TAPE_FF		(CMDU | 0x00db) /* t, <unknown> */
#define CMD_TAPE_STOP		(CMDU | 0x00dd) /* t, <unknown> */
#define CMD_TAPE_CONTINUE	(CMDU | 0x06df) /* t, <unknown> */
#define CMD_TAPE_STS_REQ	(CMDU | 0x06de) /* t, <unknown> */

#endif /* _VH7PC_H_ */
